% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectArgs.R
\name{collectArgs-and-iterateWithArgs}
\alias{collectArgs-and-iterateWithArgs}
\alias{collectArgs}
\alias{iterateWithArgs}
\title{collectArgs and iterateWithArgs}
\usage{
collectArgs(except = c(), incl.dots = TRUE, all.names = TRUE,
  envir = parent.frame())

iterateWithArgs(arg_to_iterate_over, FUNC,
  nm.arg_to_iterate_over = as.character(substitute(arg_to_iterate_over)),
  except = c(), incl.dots = TRUE, envir = parent.frame())
}
\arguments{
\item{except}{A vector of string values. Objects to \emph{NOT} include in the collection
Generally, the user will not want to pass objets created inside the function and hence will pass to except
_NOTE_ pass the quoted string-name of the object, not the object itself.}

\item{incl.dots}{A single logical value. Should the \code{...} be collected as well?
\emph{NOTE: Has no effect in functions without dots argument}
 Default is \code{TRUE}.}

\item{all.names}{A single logical value. Passed to \code{ls()}. When \code{FALSE}, then objects whose name begins with a '.' are omitted from the collection}

\item{envir}{An \code{environment} object. Passed to \code{ls()}. The environment from which to collect the objects. Defaults to \code{parent.frame}}

\item{arg_to_iterate_over}{Object, not the string-name of the object.}

\item{FUNC}{function or string of length 1. function to iterate over.  Normally the same function in which \code{iterateWithArgs} is being called}

\item{nm.arg_to_iterate_over}{The string-name of the object. 

       Default is \code{as.character(substitute(arg_to_iterate_over))}}
}
\value{
for \code{collectArgs}: A list of all of the objects in \code{envir} (less any objects excluded via the parameters). The names of the list are the names of object in \code{envir}.

for \code{iterateWithArgs}: A list of the return values of \code{FUNC}, the length of \code{arg_to_iterate_over}. Naming of the list will be handled by \code{\link[base]{do.call}}
}
\description{
Functions to cleanly collect arguments from within one function or environment (to then pass to another or to iterate over)
}
\details{
\code{collectArgs()} colects objects from an envrionment into a single list. Generally, the list will then be passed to other functions (usually with \code{\link[base]{do.call}})

\code{iterateWithArgs()} similarly collects the objects in an environment, with the difference that one specific object is selected to iterate over. For each iteration, the given value is passed along with all the other objects to \code{FUNC}.
}
\examples{
sample_function <- function(x, base, thresh=500, verbose=TRUE) {

  some_object    <- is.na(x) ## an example of an object that we will exclude
  another_object <- 1:10     ## an example of an object that we will exclude

  if (length(x) > 1) {
    return(iterateWithArgs(x, FUNC=sample_function, except=c("some_object", "another_object")))
  }

  ret <- (base ^ x)

  if (verbose)
    cat(base, "^", x, " is ", ifelse(ret > thresh, "", "NOT "), "larger than ", thresh, "\\n")

  return(ret)
}

sample_function(5, base=2)
sample_function(5:10, base=2)


 some_function <- function(x, param1, param2, etc, ...) {

   ARGS <- collectArgs(except="x")
   return(
           lapply(x, function(x_i) 
              do.call(some_function, c(ARGS, x=x_i))
           )
         )
 }
}
