% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorttools.R
\name{plotratetable}
\alias{plotratetable}
\title{Function makes plot(s) from ratetable}
\usage{
plotratetable(rt, RR = FALSE)
}
\arguments{
\item{rt}{Rate table produced by function mkratetable}

\item{RR}{Boolean, if TRUE rate ratios plotted}
}
\value{
ggplot object, or list if multiple variables in rate table
}
\description{
Function makes plot(s) from ratetable
}
\examples{
library(ggplot2)
library(survival)
tmp.lt1<-mkratetable(Surv(time,status)~ ph.ecog,data=lung,add.RR = FALSE)
plotratetable(tmp.lt1)
tmp.lt2<-mkratetable(Surv(time,status)~ sex+ph.ecog+cut(age,4),data=lung,add.RR=TRUE,lowest.N=1)
plotratetable(tmp.lt2,TRUE)
}
