% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAC_change.R
\name{RAC_change}
\alias{RAC_change}
\title{Rank Abundance Curve Changes}
\usage{
RAC_change(df, time.var, species.var, abundance.var, replicate.var = NULL,
  reference.time = NULL)
}
\arguments{
\item{df}{A data frame containing time, species, and abundance columns and an optional columns of replicates.}

\item{time.var}{The name of the time column}

\item{species.var}{The name of the species column}

\item{abundance.var}{The name of the abundance column}

\item{replicate.var}{The name of the optional replicate column. If specified, replicate must be unique within the dataset and cannot be nested within treatments or blocks.}

\item{reference.time}{The name of the optional time point that all other time points should be compared to (e.g. the first year of data). If not specified, each comparison is between consecutive time points (the first and second year, second and third year, etc.)}
}
\value{
The RAC_change function returns a data frame with the following attributes:
\itemize{
 \item{replicate.var: }{A column that has same name and type as the replicate.var column, if replicate.var is specified.}
 \item{time.var: }{A column with the specified time.var and a second column, with '2' appended to the name. Time is subtracted from time2.}
 \item{richness_change: }{A numeric column that is the change in richness between the two time periods for a replicate divided by the total number of unique species in both time periods. A positive value occurs when a there is an increase in species richness over time, and a negative value when there is a decreases in species richness over  time.}
 \item{evenness_change: }{A numeric column that is the change in evenness(measured with Evar) between the two time periods for a replicate. A positive value occurs when evenness  increases over time, and a negative value when evenness decreases in over time.}
 \item{rank_change: }{A numeric column that is the absolute value of the average change in species ranks between the two time periods for a replicate divided by the total number of unique species in both time periods. Species that are not present in both time periods are given the S+1 rank in the sample it is absent in, where S is the number of species in that sample.}
 \item{gains: }{A numeric column of the number of species that are present at time period 2 that were not present at time period 1 for a replicate divided by the total number of unique species in both time periods. This is equivalent to the turnover function with metric = "appearances".}
 \item{losses: }{A numeric column of the number of species that are not present at time period 2 but were  present at time period 1 for a replicate divided by the total number of unique species in both time periods. This is equivalent to the turnover function with metric = "disappearance".}
}
}
\description{
Calculates change of the five aspects of rank abundance curves (richness, evenness, rank, species gains, and species losses) for a replicate between two time points.
}
\examples{
data(pplots)
# Without replicates
df <- subset(pplots, plot == 25)
RAC_change(df = df,
           species.var = "species",
           abundance.var = "relative_cover",
           time.var = "year")

# With replicates
df <- subset(pplots, year < 2004 & plot \%in\% c(6, 25, 32))
RAC_change(df = df,
           species.var = "species",
           abundance.var = "relative_cover",
           replicate.var = "plot",
           time.var = "year")
           
# With reference year
df <- subset(pplots, year < 2005 & plot \%in\% c(6, 25, 32))
RAC_change(df = df,
           species.var = "species",
           abundance.var = "relative_cover",
           replicate.var = "plot",
           time.var = "year",
           reference.time = 2002)

}
\references{
Avolio et al. submitted to MEE
}
