% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_for_datasets.R
\docType{data}
\name{elixhauser}
\alias{elixhauser}
\title{Classcodes for Elixhauser based on ICD-codes}
\format{
A data frame with 31 rows and 8 variables:
\describe{
\item{group}{comorbidity groups}
\item{icd10}{regular expressions identifying ICD-10 codes of
each group. Corresponds to column 'ICD-10' in table 2
of Quan et al. (2005).}
\item{icd10_short}{regular expressions identifying only the first
three characters of ICD-10 codes of each group. This alternative version
was added only to use in emergency when only the first three digits are
available. It is not an official version and we do not recommend to
use it!}
\item{icd9cm}{Corresponds to column 'Elixhauser's Original ICD-9-CM'
in table 2 of Quan et al. (2005).}
\item{icd9cm_ahrqweb}{Corresponds to column
'Elixhauser AHRQ-Web ICD-9-CM' in table 2 of Quan et al. (2005).}
\item{icd9cm_enhanced}{Corresponds to column 'Enhanced ICD-9-CM'
in table 2 of Quan et al. (2005).}
\item{sum_all}{all weights = 1 (thus no weights)}
\item{sum_all_ahrq}{as \code{sum_all} excluding "cardiac arrhythmia.
Compare to \code{icd9cm_ahrqweb} which does not
consider this condition.}
\item{walraven}{weights suggested by Walraven et al. (2009)}
\item{sid29}{weights suggested by Thompson et al. (2015)
based on all conditions except cardiac arrhythmia}
\item{sid30}{weights suggested by Thompson et al. (2015)
based on all conditions}
\item{ahrq_mort}{weights for in-hospital mortality suggested by
Moore et al. (2017)}
\item{ahrq_readm}{weights for readmissions suggested by
Moore et al. (2017)}
}
}
\usage{
elixhauser
}
\description{
Solid tumors are subordinate to metastatic cancer. A patient with both
conditions will still be classified as such but a possible (weighted)
index value will only account for metastatic cancer. The same is true for
"diabetes uncomplicated", which is subordinate of "diabetes complicated".
See Elixhauser et al. (1998).
}
\details{
Note that "DRG screen" as proposed in table 1 of Elixhauser et al. (1998)
is not handled by the coder package. This should instead be considered as
an additional pre- or post-processing step!
}
\references{
Elixhauser A, Steiner C, Harris DR, Coffey RM (1998).
Comorbidity Measures for Use with Administrative Data.
Med Care. 1998;36(1):8–27.

Moore, B. J., White, S., Washington, R., Coenen, N., & Elixhauser, A. (2017).
Identifying Increased Risk of Readmission and In-hospital Mortality Using
Hospital Administrative Data.
Medical Care, 55(7), 698–705.
\doi{10.1097/MLR.0000000000000735}

Quan Hude et al. (2005). Coding algorithms for defining
comorbidities in ICD-9-CM and ICD-10 administrative data.
Medical care, 1130-1139.
\url{https://www.jstor.org/stable/3768193}

Thompson, N. R., Fan, Y., Dalton, J. E., Jehi, L., Rosenbaum, B. P.,
Vadera, S., & Griffith, S. D. (2015).
A new Elixhauser-based comorbidity summary measure to predict in-hospital
mortality. Med Care, 53(4), 374–379.
\doi{10.1097/MLR.0000000000000326}

Walraven, C. Van, Austin, P. C., Jennings, A., Quan, H., Alan, J., Walraven,
C. Van, … Jennings, A. (2009).
A Modification of the Elixhauser Comorbidity Measures Into a Point System
for Hospital Death Using Administrative Data.
Medical Care, 47(6), 626–633.
}
\seealso{
Other default classcodes: 
\code{\link{ae}},
\code{\link{charlson}},
\code{\link{cps}},
\code{\link{hip_ae_hailer}},
\code{\link{rxriskv}}
}
\concept{default classcodes}
\keyword{datasets}
