% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_longitudinal_functions.R
\name{plot_signature_curves}
\alias{plot_signature_curves}
\title{plot_signature_curves}
\usage{
plot_signature_curves(
  varNum,
  coeff,
  X,
  Y,
  x_time,
  subject_id,
  ini_time,
  end_time
)
}
\arguments{
\item{varNum}{column number of the variables (taxa)}

\item{coeff}{coefficients (coefficients must sum-up zero)}

\item{X}{microbiome abundance matrix in long format}

\item{Y}{binary outcome}

\item{x_time}{observation times}

\item{subject_id}{subject id}

\item{ini_time}{initial time to be analyzed}

\item{end_time}{end time to be analyzed}
}
\value{
trajectories plot
}
\description{
Graphical representation of the signature trajectories
}
\examples{

x=matrix(c(2, 3, 4, 1, 2, 5, 10, 20, 15, 30, 40, 12), ncol=2)
x_time = c(0,10,20,1,15, 25)
subject_id = c(1,1,1,2,2,2)
y=c(0,0,0,1,1,1)
plot_signature_curves(varNum=c(1,2), coeff=c(1,-1), x, y,x_time, subject_id,
                       ini_time=0, end_time=25)

}
\author{
M. Calle - T. Susin
}
