% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{coordinates}
\alias{coordinates}
\title{coordinates with respect an specific basis}
\usage{
coordinates(X, basis = "ilr", label = "x", sparse_basis = FALSE)
}
\arguments{
\item{X}{compositional dataset. Either a matrix, a data.frame or a vector}

\item{basis}{basis used to calculate the coordinates. \code{basis} can be either a string or a matrix.
Accepted values for strings are: 'ilr' (default), 'clr', 'alr' and 'pc'. If \code{basis} is a matrix, it is expected
to have log-ratio basis given in columns.}

\item{label}{name given to the coordinates}

\item{sparse_basis}{Is the given matrix basis sparse? If TRUE calculation are carried
taking into an account sparsity (default `FALSE`)}
}
\value{
coordinates with respect the given basis
}
\description{
Calculate the coordinates of a composition with respect a given basis
}
\examples{
coordinates(c(1,2,3,4,5))
# Setting sparse_basi to TRUE can improve performance if log-ratio basis is sparse.
N = 100
K = 1000
X = matrix(exp(rnorm(N*K)), nrow=N, ncol=K)
system.time(coordinates(X, alr_basis(K), sparse_basis = FALSE))
system.time(coordinates(X, alr_basis(K), sparse_basis = TRUE))
system.time(coordinates(X, 'alr', sparse_basis = TRUE))
}
\seealso{
See functions \code{\link{ilr_basis}}, \code{\link{alr_basis}},
\code{\link{clr_basis}}, \code{\link{sbp_basis}}
to define different compositional basis.
See function \code{\link{composition}} to obtain details on how to calculate
a compositions from given coordinates.
}
