% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.stats.station.data.R
\name{cmsaf.stats.station.data}
\alias{cmsaf.stats.station.data}
\title{Calculates the rmse, mae, bias, correlation over time
of a NetCDF file and a dataframe (station data).
Designed for the CM SAF R Toolbox.}
\usage{
cmsaf.stats.station.data(var, infile, data_station, outfile, overwrite = FALSE)
}
\arguments{
\item{var}{Name of NetCDF variable of NetCDF file (character).}

\item{infile}{Filename of input NetCDF file. This may include
the directory (character).}

\item{data_station}{Dataframe of RData or csv file (station data);
Designed for the CM SAF R Toolbox.}

\item{outfile}{Filename of output csv file. This may include the directory
(character).}

\item{overwrite}{logical; should existing output file be overwritten?; Default: FALSE}
}
\value{
A csv file including the rmse, mae, bias and correlation over time
is written.
}
\description{
Calculates the rmse, mae, bias, correlation over time
of a NetCDF file and a dataframe (station data).
Designed for the CM SAF R Toolbox.
}
\seealso{
Other metrics: 
\code{\link{cmsaf.stats}()}
}
\concept{metrics}
