% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowops.R
\name{rowops}
\alias{replacerow}
\alias{rowops}
\alias{scalerow}
\alias{swaprows}
\title{Elementary row operations}
\usage{
swaprows(m, row1, row2)

replacerow(m, row1, row2, k)

scalerow(m, row, k)
}
\arguments{
\item{m}{a matrix}

\item{row1}{a source row}

\item{row2}{a destination row}

\item{k}{a scaling factor}

\item{row}{a row to modify}
}
\value{
the modified matrix
}
\description{
These are elementary operations for a matrix.  They do not presume a
square matrix and will work on any matrix.  They use R's internal row
addressing to function.
}
\details{
\code{replacerow} replaces one row with the sum of itself and the
multiple of another row.  \code{swaprows} swap two rows in the
matrix.  \code{scalerow} scales all enteries in a row by a constant.
}
\examples{
n <- 5
A <- matrix(sample.int(10, n^2, TRUE) - 1, n)
A <- swaprows(A, 2, 4)
A <- replacerow(A, 1, 3, 2)
A <- scalerow(A, 5, 10)
}
\seealso{
Other linear: \code{\link{choleskymatrix}},
  \code{\link{detmatrix}}, \code{\link{gdls}},
  \code{\link{invmatrix}}, \code{\link{iterativematrix}},
  \code{\link{lumatrix}}, \code{\link{refmatrix}},
  \code{\link{tridiagmatrix}}, \code{\link{vecnorm}}
}

