% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision.R
\name{decision_CMC}
\alias{decision_CMC}
\title{Applies the decision rules of the original method of Song (2013) or the High
CMC method of Tong et al. (2015)}
\usage{
decision_CMC(
  cellIndex,
  x,
  y,
  theta,
  corr,
  xThresh = 20,
  yThresh = xThresh,
  thetaThresh = 6,
  corrThresh = 0.5,
  tau = NULL
)
}
\arguments{
\item{cellIndex}{vector/tibble column containing cell indices corresponding to
a reference cell}

\item{x}{vector/tibble column containing x horizontal translation values}

\item{y}{vector/tibble column containing y vertical translation values}

\item{theta}{vector/tibble column containing theta rotation values}

\item{corr}{vector/tibble column containing correlation similarity scores
between a reference cell and its associated target region}

\item{xThresh}{used to classify particular x values "congruent" (conditional
on a particular theta value) if they are within xThresh of the
theta-specific median x value}

\item{yThresh}{used to classify particular y values "congruent" (conditional
on a particular theta value) if they are within yThresh of the
theta-specific median y value}

\item{thetaThresh}{(original method of Song (2013)) used to classify
particular theta values "congruent" if they are within thetaThresh of the
median theta value. (High CMC) defines how wide a High CMC mode is allowed
to be in the CMC-theta distribution before it's considered too diffuse}

\item{corrThresh}{to classify particular correlation values "congruent"
(conditional on a particular theta value) if they are at least corrThresh}

\item{tau}{(optional) parameter required to apply the High CMC method of Tong
et al. (2015). If not given, then the decision rule of the original method
of Song (2013) is applied. This number is subtracted from the maximum CMC
count achieved in the CMC-theta distribution. Theta values with CMC counts
above this value are considered to have "high" CMC counts.}
}
\value{
A vector of the same length as the input containing the CMC
classification under one of the two decision rules.
}
\description{
Applies the decision rules of the original method of Song (2013) or the High
CMC method of Tong et al. (2015)
}
\examples{
\dontrun{
data(fadul1.1_processed,fadul1.2_processed)

comparisonDF <- purrr::map_dfr(seq(-30,30,by = 3),
                              ~ comparison_allTogether(fadul1.1_processed,
                                                       fadul1.2_processed,
                                                       theta = .))


comparisonDF <- comparisonDF \%>\%
dplyr::mutate(originalMethodClassif = decision_CMC(cellIndex = cellIndex,
                                                   x = x,
                                                   y = y,
                                                   theta = theta,
                                                   corr = pairwiseCompCor),
              highCMCClassif = decision_CMC(cellIndex = cellIndex,
                                           x = x,
                                           y = y,
                                           theta = theta,
                                           corr = pairwiseCompCor,
                                           tau = 1))


comparisonDF \%>\%
dplyr::filter(originalMethodClassif == "CMC" | highCMCClassif == "CMC")
}
}
\seealso{
\url{https://tsapps.nist.gov/publication/get_pdf.cfm?pub_id=911193}

\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4730689/pdf/jres.120.008.pdf}
}
