% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_cor}
\alias{comparison_cor}
\title{Calculates correlation between a cell and a matrix of the same dimensions
extracted from the cell's associated region.}
\usage{
comparison_cor(
  cellHeightValues,
  regionHeightValues,
  fft_ccf_df,
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{cellHeightValues}{list/tibble column of x3p objects containing a
reference scan's cells (as returned by comparison_cellDivision)}

\item{regionHeightValues}{list/tibble column of x3p objects containing a
target scan's regions (as returned by comparison_getTargetRegions)}

\item{fft_ccf_df}{data frame/tibble column containing the data frame of (x,y)
and CCF values returned by comparison_fft_ccf}

\item{use}{argument for stats::cor}
}
\value{
A vector of the same length as the input containing correlation values
at the estimated alignment between each reference cell and its associated
target region
}
\description{
Calculates correlation between a cell and a matrix of the same dimensions
extracted from the cell's associated region.
}
\examples{
data(fadul1.1_processed,fadul1.2_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = 64) \%>\%
dplyr::mutate(regionHeightValues =
             comparison_getTargetRegions(cellHeightValues = cellHeightValues,
                                         target = fadul1.2_processed)) \%>\%
dplyr::mutate(cellPropMissing =
           comparison_calcPropMissing(heightValues = cellHeightValues),
              regionPropMissing =
           comparison_calcPropMissing(heightValues = regionHeightValues)) \%>\%
dplyr::filter(cellPropMissing <= .85 & regionPropMissing <= .85) \%>\%
dplyr::mutate(cellHeightValues =
        comparison_standardizeHeights(heightValues = cellHeightValues),
              regionHeightValues =
        comparison_standardizeHeights(heightValues = regionHeightValues)) \%>\%
dplyr::mutate(cellHeightValues =
                  comparison_replaceMissing(heightValues = cellHeightValues),
              regionHeightValues =
            comparison_replaceMissing(heightValues = regionHeightValues)) \%>\%
dplyr::mutate(fft_ccf_df = comparison_fft_ccf(cellHeightValues,
                                              regionHeightValues)) \%>\%
dplyr::mutate(pairwiseCompCor = comparison_cor(cellHeightValues,
                                               regionHeightValues,
                                               fft_ccf_df))

head(cellTibble)

}
