% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{generate_report_cmahalanobis}
\alias{generate_report_cmahalanobis}
\title{Generate a Microsoft Word document about Mahalanobis distance matrix and p-values matrix with corresponding plots.}
\usage{
generate_report_cmahalanobis(
  dataset,
  formula,
  pvalue.method = "chisq",
  num.permutations = 10,
  num.bootstraps = 10
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A factor which you want to calculate Mahalanobis distances matrix and p_values matrix.}

\item{pvalue.method}{A method with which you want to calculate pvalue matrix.The default method is "chisq". Other methods are "permutation" and "bootstrap".}

\item{num.permutations}{A number of permutations to define if you choose "permutation".}

\item{num.bootstraps}{A number of bootstrap to define if you choose "bootstrap".}
}
\value{
A Microsoft Word document about Mahalanobis distances matrix and p_values matrix.
}
\description{
This function takes a dataframe, a factor and returns a Microsoft Word document about Mahalanobis distance matrix and p-values matrix with corresponding plots.
}
\examples{
# Generate a report about "Species" factor in iris dataset
generate_report_cmahalanobis(iris, ~Species)

# Generate a report about "am" factor in mtcars dataset
generate_report_cmahalanobis(mtcars, ~am)

}
