% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmr_space.R
\name{cmr.space}
\alias{cmr.space}
\title{Spatial spline analysis of cardiovascular magnetic resonance imaging}
\usage{
cmr.space(data, mask, input, quantiles = c(0.25, 0.75))
}
\arguments{
\item{data}{3d array of CMR signal}

\item{mask}{2d array of mask. Voxel with 0 or FALSE will be omitted from analysis}

\item{input}{input function}

\item{quantiles}{quantiles used for credible interval, default: c(0.25, 0.75)}
}
\value{
list of mbf (point estimation) and ci (credible interval)
}
\description{
Spatial spline analysis of cardiovascular magnetic resonance imaging
}
\examples{
\donttest{
oldpar <- par(no.readonly = TRUE)
 library(cmR)
 data(cmrsim)
 mask=array(NA,c(30,30))
 space.mbf=space.ci=array(NA,c(30,30,3))
 for (i in 1:3){
  mask=array(NA,c(30,30))
  mask[cmrdata_sim[,,i,1]!=0]=1
  temp=cmr.space(cmrdata_sim[,,i,], mask, input_sim)
  space.mbf[,,i]=t(as.matrix(temp$mbf))
  space.ci[,,i]=t(as.matrix(temp$ci))
  }
 par(mfrow=c(2,1))
 imageMBF(maxresp_sim, zlim=c(0,5))
 imageMBF(space.mbf, zlim=c(0,5))
 imageMBF(space.ci, zlim=c(0,0.8))
 par(oldpar)
}

}
