% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateCardData.R
\name{simulateCardData}
\alias{simulateCardData}
\title{Simulate Card Sorting Data}
\usage{
simulateCardData(
  nSorters = 40,
  pCorrect = 0.95,
  attributeWeights = c(1, 1, 1, 1),
  verbose = TRUE
)
}
\arguments{
\item{nSorters}{An integer specifying the number of sorters to simulate. Default is 40.}

\item{pCorrect}{A numeric value between 0 and 1 specifying the probability that
a card is sorted correctly. Default is 0.95.}

\item{attributeWeights}{A numeric vector of length 4 specifying the weights
for the card attributes (e.g., \code{color}, \code{suit}, \code{rank_picture},
and \code{odd_even_picture}). Default is \code{c(1, 1, 1, 1)}.}

\item{verbose}{Logical, if \code{TRUE}, additional information about the processing
steps is printed to the console.}
}
\value{
A data frame with columns:
\describe{
\item{\code{sorterID}}{A unique identifier for each sorter.}
\item{\code{statement}}{The ID of the card being sorted.}
\item{\code{stackID}}{The stack assigned to the card by the sorter.}
}
}
\description{
This function simulates card sorting data based on user-specified parameters,
such as the number of sorters, the probability of correct sorting, and the
weights for different card attributes.
}
\details{
The function simulates a card sorting experiment where cards are
sorted by multiple sorters based on one of four attributes. The probability
of sorting a card correctly is determined by \code{pCorrect}, and errors are
introduced randomly for each sorter. The attribute weights determine how many
sorters focus on each attribute, and a warning is issued if the weights do
not align with the total number of sorters.

The function returns a data frame containing simulated card sorting data
for all sorters, including sorter IDs, card IDs, and assigned stacks.
}
\examples{
# Simulate data with default parameters:
set.seed(1)
myCMData <- simulateCardData()

# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

}
\seealso{
\code{\link[stats]{rbinom}}, \code{\link[base]{sample}}
}
