% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{oneid}
\alias{oneid}
\title{Generates data for one \code{id}}
\usage{
oneid(id, n_obs, type, start, end, smin, emax, reference, noise)
}
\arguments{
\item{id}{A unique integer.}

\item{n_obs}{An integer number of observations to produce.}

\item{type}{Response type, 1 is constant, 2 is a sin curve portion, and 3 is a sigmoid
portion.}

\item{start}{Negative integer giving time of first observation.}

\item{end}{Positive integer giving time of last observation.}

\item{smin}{The smallest possible \code{start} value among all \code{id}s. Currently not used.}

\item{emax}{The largest possible \code{end} value among all \code{id}s. Used to scale sin and
sigmoid support.}

\item{reference}{A response value for constant response. Also used to scale sin and sigmoid
responses.}

\item{noise}{Standard deviation of zero mean Gaussian noise added to response functions.}
}
\value{
An \code{n_obs} by 4 matrix with columns \code{id}, \code{time}, \code{response}, \code{true_group}.
}
\description{
Generates data for one \code{id}
}
