% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTestData.R
\name{generateTestData_2D}
\alias{generateTestData_2D}
\title{Generate simulated 2D dataset for testing}
\usage{
generateTestData_2D(groupCounts, means, variances = NULL)
}
\arguments{
\item{groupCounts}{Number of data samples in each global cluster.
It is assumed to be a vector of four elements: \code{ c(c11, c21, c12, c22)}
where \code{cij} is the number of samples coming from cluster i in context 1
and cluster j in context 2.}

\item{means}{Means of the simulated clusters.
It is assumed to be a vector of two elements: \code{ c(m1, m2)}
where \code{m1} is the mean of the first cluster in both contexts,
and \code{m2} is the mean of the second cluster in both contexts.
Because the data are two-dimensional, the mean is assumed to be the
same in both dimensions.}

\item{variances}{Optionally, it is possible to specify different variance
for each of the clusters. The variance is assumed to be a vector
of two elements: \code{ c(v1, v2)}
where \code{v1} is the variance of the first cluster in both contexts,
and \code{v2} is the variance of the second cluster in both contexts.
Because the data are two-dimensional, the variance is diagonal and the
same in both dimensions.}
}
\value{
Returns the simulated datasets together with true assignmets.
  \item{data}{List of datasets for each context. This can be used as an input
     for the \code{contextCluster} function.}
  \item{groups}{True cluster assignments that were used to generate the data.}
}
\description{
Generate simple 2D dataset with two contexts, where the data are generated
from Gaussian distributions.
The generated output contains two datasets, where
each dataset contains 4 global clusters, originating from
two local clusters in each context.
}
\examples{
groupCounts <- c(50, 10, 40, 60)
means <- c(-1.5,1.5)
testData <- generateTestData_1D(groupCounts, means)
# Use the dataset as an input for the contextCluster function for testing
datasets <- testData$data

}

