% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterIM.ivreg.R
\name{cluster.im.ivreg}
\alias{cluster.im.ivreg}
\title{Cluster-Adjusted Confidence Intervals And p-Values For GLM}
\usage{
cluster.im.ivreg(mod, dat, cluster, ci.level = 0.95, report = TRUE,
  drop = FALSE)
}
\arguments{
\item{mod}{A model estimated using \code{ivreg}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{ci.level}{What confidence level should CIs reflect?}

\item{report}{Should a table of results be printed to the console?}

\item{drop}{Should clusters within which a model cannot be estimated be dropped?}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{ci}{A matrix of confidence intervals.}
}
\description{
Computes p-values and confidence intervals for GLM models based on cluster-specific model estimation (Ibragimov and Muller 2010). A separate model is estimated in each cluster, and then p-values and confidence intervals are computed based on a t/normal distribution of the cluster-specific estimates.
}
\note{
Confidence intervals are centered on the cluster averaged estimate, which can diverge from original model estimates if clusters have different numbers of observations. Consequently, confidence intervals may not be centered on original model estimates. If drop = TRUE, any cluster for which all coefficients cannot be estimated will be automatically dropped from the analysis.
}
\examples{
\dontrun{

# example: pooled IV analysis of employment
require(plm)
require(AER)
data(EmplUK)
EmplUK$lag.wage <- lag(EmplUK$wage)
emp.iv <- ivreg(emp ~ wage + log(capital+1) | output + lag.wage + log(capital+1), data = EmplUK)

# compute cluster-adjusted p-values
cluster.im.e <- cluster.im.ivreg(mod=emp.iv, dat=EmplUK, cluster = ~firm)

}
}
\author{
Justin Esarey
}
\references{
Ibragimov, Rustam, and Ulrich K. Muller. 2010. "t-Statistic Based Correlation and Heterogeneity Robust Inference." \emph{Journal of Business & Economic Statistics} 28(4): 453-468. <DOI:10.1198/jbes.2009.08046>.
}

