% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.irgtt.normal.R
\name{cpa.irgtt.normal}
\alias{cpa.irgtt.normal}
\title{Power calculations for individually randomized group treatment trials, continuous outcome}
\usage{
cpa.irgtt.normal(
  alpha = 0.05,
  power = 0.8,
  nclusters = NA,
  nsubjects = NA,
  ncontrols = NA,
  d = NA,
  varu = NA,
  varei = NA,
  varr = NA,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{nclusters}{The number of clusters in the intervention arm.}

\item{nsubjects}{The number of subjects in each cluster in the intervention arm.}

\item{ncontrols}{The number of subjects in the control arm.}

\item{d}{The expected treatment effect.}

\item{varu}{The variance of the cluster level random effect for clusters 
in the intervention arm.}

\item{varei}{The variance of the subject level random error for individuals 
in the intervention arm.}

\item{varr}{The variance of the subject level random error for individuals 
in the control arm.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
}
\description{
Compute the power of an individually randomized group treatment trial (IRGTT) design with a continuous outcome,
or determine parameters to obtain a target power.
}
\details{
Exactly one of \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{ncontrols}, \code{d}, \code{varu}, \code{varei}, and \code{varr}
  must be passed as \code{NA}. Note that \code{alpha} and \code{power}
  have non-\code{NA} defaults, so if those are the parameters of 
  interest they must be explicitly passed as \code{NA}.
}
\section{Note}{

  This function was inspired by work from Stephane Champely (pwr.t.test) and
  Peter Dalgaard (power.t.test). As with those functions, 'uniroot' is used to
  solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given.
}

\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\examples{
# Find the required number of control subjects for an IRGTT with alpha = 0.05, power = 0.80,
# nclusters = 10, nsubjects = 10, d = 0.5 units, 
# varu = 0.1, varei = 0.9, varr = 1.
cpa.irgtt.normal(nclusters=10, nsubjects = 10, 
  d = 0.5, varu = 0.1, varei = 0.9, varr = 1)
# 
# The result, ncontrols = 77.81084, suggests 78 subjects in the control arm should be recruited.
# This means that the total number of subjects in the 
# study is nclusters*nsubjects + ncontrols = 10*10 + 78 = 178.

}
\references{
Moerbeek, M. and Wong, W. K. (2008) Sample size formulae for trials comparing
group and individual treatments in a multilevel model. Statist. Med., 27:2850-2864. 
doi: 10.1002/sim.3115.
}
