library(clusterGeneration)

set.seed(12345)

# default method is "eigen"
tmp<-genRandomClust(numClust=2, sepVal=0.3, numNonNoisy=5, numNoisy=1, 
               numOutlier=5, numReplicate=1, fileName="chk0", 
               clustszind=2, clustSizeEq=50, rangeN=c(50,100), rotateind=TRUE, 
               iniProjDirMethod="SL", projDirMethod="newton", quiet=F)
print(tmp)
cat("======================================== chk0 done\n\n")

dat=read.table("chk0_1.dat",header=T)
postscript("chk0_1plot.ps")
pairs(dat)
graphics.off()

# compare the difference between the clusters generated by setting
# covMethod='eigen' and those by setting covMethod='unifcorrmat'

# next example takes a while
set.seed(12345)
tmp1.eigen <- genRandomClust(numClust=7, sepVal=0.3, numNonNoisy=5, 
    numNoisy=3, numOutlier=5, numReplicate=2, fileName="chk1a",
    lambdaLow=0.001, ratioLambda=1000, quiet=T)
print(tmp1.eigen)
cat("======================================== chk1a done\n\n")

set.seed(12345)
tmp1.unifc <- genRandomClust(numClust=3, sepVal=0.3, numNonNoisy=3, 
        numNoisy=1, numOutlier=5, numReplicate=1, fileName="chk1b", 
        covMethod="unifcorrmat",  ITMAX=20,eps=1.e-10, quiet=T)
print(tmp1.unifc)
cat("======================================== chk1b done\n\n")

# next example takes a while
set.seed(12345)
tmp2.unifc <- genRandomClust(numClust=7, sepVal=0.3, numNonNoisy=5, 
        numNoisy=3, numOutlier=5, numReplicate=2, fileName="chk2", 
        covMethod="unifcorrmat", quiet=T)
print(tmp2.unifc)
cat("======================================== chk2 done\n\n")


