% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_Theta}
\alias{get_Theta}
\alias{get_Theta.CGGM}
\alias{get_Theta.CGGM_refit}
\alias{get_Theta.CGGM_CV}
\title{Extract the Estimated Precision Matrix}
\usage{
get_Theta(object, ...)

\method{get_Theta}{CGGM}(object, index, ...)

\method{get_Theta}{CGGM_refit}(object, index, ...)

\method{get_Theta}{CGGM_CV}(object, which = NULL, ...)
}
\arguments{
\item{object}{an object from which to extract the precision matrix.}

\item{\dots}{additional arguments are currently ignored.}

\item{index}{an integer specifying the step along the clusterpath for which
to extract the precision matrix.}

\item{which}{a character string specifying for which solution to extract
the precision matrix.  Possible values are \code{"refit"} for the solution
including the refitting step (see \code{\link{cggm_refit}()}), or
\code{"fit"} for the solution without without the refitting step (see
\code{\link{cggm}()}).  If \code{NULL} (the default), the solution with the
better cross-validation score is used.}
}
\value{
The estimated (block-structured and sparse) precision matrix.

For the \code{"CGGM_CV"} method (see \code{\link{cggm_cv}()}), the returned
precision matrix corresponds to the optimal values of the tuning parameters.
}
\description{
Extract a (block-structured and sparse) precision matrix obtained via the
clusterpath estimator of the Gaussian graphical model (CGGM).
}
\examples{
# Generate data
set.seed(3)
Theta <- matrix(
  c(2, 1, 0, 0,
    1, 2, 0, 0,
    0, 0, 4, 1,
    0, 0, 1, 4),
  nrow = 4
)
X <- mvtnorm::rmvnorm(n = 100, sigma = solve(Theta))

# Estimate the covariance matrix
S <- cov(X)

# Compute the weight matrix for the clusterpath (clustering) weights
W_cpath <- clusterpath_weights(S, phi = 1, k = 2)

# Compute the weight matrix for the lasso (sparsity) weights
W_lasso <- lasso_weights(S)

# Set values to be used for the aggregation parameter
lambdas <- seq(0, 0.2, by = 0.01)

# Estimate the precision matrix while automatically expanding
# the sequence of values for the aggregation parameter
fit <- cggm(S, W_cpath = W_cpath, lambda_cpath = lambdas,
            W_lasso = W_lasso, lambda_lasso = 0.2,
            expand = TRUE)

# Precision matrix with 2 clusters
get_Theta(fit, index = fit$cluster_solution_index[2])


# Apply the refitting step to the results, estimating the
# precision matrix based on the clustering and sparsity
# patterns but without additional shrinkage
refit <- cggm_refit(fit)

# Precision matrix with 2 clusters
get_Theta(refit, index = refit$cluster_solution_index[2])
}
\references{
D.J.W. Touw, A. Alfons, P.J.F. Groenen and I. Wilms (2025)
\emph{Clusterpath Gaussian Graphical Modeling}. arXiv:2407.00644.
doi:10.48550/arXiv.2407.00644.
}
\seealso{
\code{\link{cggm}()}, \code{\link{cggm_refit}()}, \code{\link{cggm_cv}()}

\code{\link{get_clusters}()}
}
\author{
Daniel J.W. Touw
}
