% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.clustcurves.R
\name{autoplot.clustcurves}
\alias{autoplot.clustcurves}
\title{Visualization of \code{clustcurves} objects with ggplot2 graphics}
\usage{
\method{autoplot}{clustcurves}(
  object = object,
  groups_by_colour = TRUE,
  centers = FALSE,
  conf.int = FALSE,
  censor = FALSE,
  xlab = "Time",
  ylab = "Survival",
  interactive = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of \code{clustcurves} class.}

\item{groups_by_colour}{A specification for the plotting groups by color.}

\item{centers}{Draw the centroids (mean of the curves pertaining to the
same group) into the plot. By default it is \code{FALSE}.}

\item{conf.int}{Only for survival curves. Logical flag indicating whether to plot confidence intervals.}

\item{censor}{Only for survival curves. Logical flag indicating whether to plot censors.}

\item{xlab}{A title for the \code{x} axis.}

\item{ylab}{A title for the \code{y} axis.}

\item{interactive}{Logical flag indicating if an interactive plot with plotly is produced.}

\item{\ldots}{Other options.}
}
\value{
A ggplot object, so you can use common features from
ggplot2 package to manipulate the plot.
}
\description{
Useful for drawing the estimated functions grouped by
color and the centroids (mean curve of the curves pertaining to the
same group).
}
\details{
See help page of the function \code{\link[ggfortify:autoplot.survfit]{ggfortify::autoplot.survfit()}}.
}
\examples{

library(survival)
library(clustcurv)
library(ggplot2)
library(ggfortify)

# Survival


cl2 <- ksurvcurves(time = veteran$time, status = veteran$status,
x = veteran$celltype, k = 2, algorithm = "kmeans")

autoplot(cl2)
autoplot(cl2, groups_by_colour = FALSE)
autoplot(cl2, centers = TRUE)


\donttest{
# Regression

r2 <- kregcurves(y = barnacle5$DW, x = barnacle5$RC,
z = barnacle5$F, k = 2, algorithm = "kmeans")

autoplot(r2)
autoplot(r2, groups_by_colour = FALSE)
autoplot(r2, groups_by_colour = FALSE, interactive = TRUE)
autoplot(r2, centers = TRUE)

}
}
\author{
Nora M. Villanueva and Marta Sestelo.
}
