% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoclustcurv.R
\name{autoclustcurv}
\alias{autoclustcurv}
\title{Clustering multiple curves}
\usage{
autoclustcurv(y, x, z, weights = NULL, method = "survival",
  kvector = NULL, kbin = 50, h = -1, nboot = 100,
  algorithm = "kmeans", alpha = 0.05, cluster = FALSE,
  ncores = NULL, seed = NULL, multiple = FALSE,
  multiple.method = "holm")
}
\arguments{
\item{y}{Survival time (method = 'survival') or response variable (method = 'regression').}

\item{x}{Only for method = 'regression'. Dependent variable.}

\item{z}{Categorical variable indicating the population to which
the observations belongs.}

\item{weights}{Only for method = 'survival'. Censoring indicator of the survival
time of the process; 0 if the total time is censored and 1 otherwise.}

\item{method}{A character string specifying which method is used, 'survival' or 'regression'.}

\item{kvector}{A vector specifying the number of groups of curves to be
checking.}

\item{kbin}{Size of the grid over which the survival functions
are to be estimated.}

\item{h}{The kernel bandwidth smoothing parameter (for method = 'regression').}

\item{nboot}{Number of bootstrap repeats.}

\item{algorithm}{A character string specifying which clustering algorithm is used,
i.e., k-means(\code{"kmeans"}) or k-medians (\code{"kmedians"}).}

\item{alpha}{Significance level of the testing procedure. Defaults to 0.05.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
testing procedure is  parallelized. Note that there are cases
(e.g., a low number of bootstrap repetitions) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores
to be used is equal to the number of cores of the machine - 1.}

\item{seed}{Seed to be used in the procedure.}

\item{multiple}{A logical value. If  \code{TRUE} (not default), the resulted
pvalues are adjunted by using one of several methods for multiple comparisons.}

\item{multiple.method}{Correction method. See Details.}
}
\value{
A list containing the following items:
 \item{table}{A data frame containing the null hypothesis tested, the values
 of the test statistics and the obtained pvalues.}
 \item{levels}{Original levels of the variable \code{z}.}
 \item{cluster}{A vector of integers (from 1:k) indicating the cluster to
 which each curve is allocated.}
 \item{centers}{An object containing the centroids
 (mean of the curves pertaining to the samet group).}
 \item{curves}{An object containing the fitted curves for each population.}
}
\description{
Function for grouping survival or regression curves based on the k-means or
k-medians algorithm. It returns the number of groups and the assignement.
}
\details{
The adjustment methods include the Bonferroni correction ("bonferroni")
in which the p-values are multiplied by the number of comparisons.
Less conservative corrections are also included by Holm (1979) ('holm'),
Hochberg (1988) ('hochberg'), Hommel (1988) ('hommel'),
Benjamini & Hochberg (1995) ('BH' or its alias 'fdr'), and
Benjamini & Yekutieli (2001) ('BY'), respectively.
A pass-through option ('none') is also included.
}
\examples{
\donttest{
library(clustcurv)
library(survival)
library(condSURV)
data(veteran)
data(colonCS)

# Survival framework
res <- autoclustcurv(y = veteran$time, z = veteran$celltype,
weights = veteran$status, method = 'survival', algorithm = 'kmeans')

# Regression framework
res2 <- autoclustcurv(y = barnacle5$DW, x = barnacle5$RC, z = barnacle5$F,
method = 'regression', algorithm = 'kmeans', nboot = 20)
}
}
\author{
Nora M. Villanueva and Marta Sestelo.
}
