% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kprototypes.R
\name{plot.kproto}
\alias{plot.kproto}
\title{Assign k-Prototypes Clusters}
\usage{
\method{plot}{kproto}(x, ...)
}
\arguments{
\item{x}{Object resulting from a call of \code{kproto}.}

\item{\dots}{Additional arguments to be passet to \code{\link{clprofiles}} such as e.g. \code{vars}.}
}
\description{
Plot distributions of the clusters across the variables.
}
\details{
Wrapper around \code{\link{clprofiles}}. Only works for \code{kproto} object created with \code{keep.data = TRUE}.
}
\examples{
# generate toy data with factors and numerics

n   <- 100
prb <- 0.9
muk <- 1.5 
clusid <- rep(1:4, each = n)

x1 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x1 <- c(x1, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x1 <- as.factor(x1)

x2 <- sample(c("A","B"), 2*n, replace = TRUE, prob = c(prb, 1-prb))
x2 <- c(x2, sample(c("A","B"), 2*n, replace = TRUE, prob = c(1-prb, prb)))
x2 <- as.factor(x2)

x3 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))
x4 <- c(rnorm(n, mean = -muk), rnorm(n, mean = muk), rnorm(n, mean = -muk), rnorm(n, mean = muk))

x <- data.frame(x1,x2,x3,x4)

# apply k-prototyps
kpres <- kproto(x, 4)
plot(kpres, vars = c("x1","x3")) 


}
\author{
\email{gero.szepannek@web.de}
}
