% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions_Rcpp.R
\name{scoring_functions}
\alias{scoring_functions}
\title{Scoring Functions of a Graph Partition}
\usage{
scoring_functions(
  g,
  com,
  no_clustering_coef = TRUE,
  type = "local",
  weighted = TRUE,
  w_max = NULL
)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object). If the edges have 
a "weight" attribute, those will be used as weights (otherwise, all edges are assumed to be 1).}

\item{com}{Community membership integer vector. Each element corresponds to a vertex
of the graph, and contains the index of the community it belongs to.}

\item{no_clustering_coef}{Logical. If TRUE, skips the computation of the clustering
coefficient (which can be slow on large graphs).}

\item{type}{can be "local" for a cluster by cluster analysis, or "global" for
a global analysis of the whole graph partition.}

\item{weighted}{Is the graph weighted? If it is, doesn't compute TPR score.}

\item{w_max}{Numeric. Upper bound for edge weights. Should be generally left as default (NULL).
Only affects the computation of the clustering coefficient.}
}
\value{
If \code{type=="local"}, returns a dataframe with a row for each
community, and a column for each score. If \code{type=="global"}, returns a
single row with the weighted average scores.
}
\description{
Computes the scoring functions of a graph and its clusters.
}
\examples{
data(karate, package="igraphdata")
scoring_functions(karate, membership(cluster_louvain(karate)))
}
