% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions_Rcpp.R
\name{average_odf}
\alias{average_odf}
\title{Average Out Degree Fraction}
\usage{
average_odf(g, com)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object). If the edges have a "weight" attribute, those will be used as weights (otherwise, all edges are assumed to be 1).}

\item{com}{Community membership integer vector. Each element corresponds to a vertex
of the graph, and contains the index of the community it belongs to.}
}
\value{
Numeric vector with the Average ODF of each community.
}
\description{
Computes the Average Out Degree Fraction (Average ODF) of a graph (which can be weighted)
and its communities.
}
\examples{
data(karate, package="igraphdata")
average_odf(karate, membership(cluster_louvain(karate)))
}
\seealso{
Other cluster scoring functions: 
\code{\link{FOMD}()},
\code{\link{average_degree}()},
\code{\link{conductance}()},
\code{\link{coverage}()},
\code{\link{cut_ratio}()},
\code{\link{density_ratio}()},
\code{\link{edges_inside}()},
\code{\link{expansion}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{weighted_clustering_coefficient}()},
\code{\link{weighted_transitivity}()}
}
\concept{cluster scoring functions}
