% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage-data.R
\name{clrdata}
\alias{clrdata}
\title{Create an object of \code{clrdata}}
\usage{
clrdata(x, order_by, support_grid)
}
\arguments{
\item{x}{A vector containing the time series values}

\item{order_by}{A corresponding vector of unique time-dates - must be of
class 'POSIXct'}

\item{support_grid}{A vector corresponding to the support grid of functional
data}
}
\value{
An object of class \code{clrdata} with one function a row. As it
inherits the \code{matrix} class, all \code{matrix} methods remain valid.
}
\description{
\code{clrdata} is used to create a \code{clrdata} object from raw data
inputs.
}
\examples{
library(clr)
data(gb_load)

clr_load <- clrdata(x = gb_load$ENGLAND_WALES_DEMAND,
                    order_by = gb_load$TIMESTAMP,
                    support_grid = 1:48)

head(clr_load)
dim(clr_load)
summary(clr_load)

matplot(t(clr_load), ylab = 'Daily loads', type = 'l')
lines(colMeans(clr_load, na.rm = TRUE),
      col = 'black', lwd = 2)


clr_weather <- clrdata(x = gb_load$TEMPERATURE,
                       order_by = gb_load$TIMESTAMP,
                       support_grid = 1:48)
summary(clr_weather)
plot(1:48,
     colMeans(clr_weather, na.rm = TRUE),
     xlab = 'Instant', ylab = 'Mean of temperatures',
     type = 'l', col = 'cornflowerblue')
}
