% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{check_bool}
\alias{check_bool}
\title{Check if Argument is Single TRUE or FALSE}
\usage{
check_bool(x, alt_null = FALSE, add_msg = NULL)
}
\arguments{
\item{x}{Function argument that is being asserted.}

\item{alt_null}{Logical. Should argument accept \code{NULL} value.}

\item{add_msg}{Is an additional message that can be printed over the standard
function error message. You can:
\itemize{
\item pass the names of the arguments that failed the test by using
\code{{x_name}} in the message body (e.g. "What are the \{x_name\}");
\item pass the class of the arguments that failed the test by using
\code{{wrong_class}} in the message body (e.g. "\{wrong_class\} is wrong")
}}
}
\value{
If argument is single \code{TRUE} or \code{FALSE} (optionally \code{NULL}) it
returns invisible \code{NULL}. Otherwise the function throws an error.
}
\description{
Check if an argument is single TRUE or FALSE. As an option it is
possible to allow \code{NULL} value when \code{alt_null = TRUE}.
}
\keyword{internal}
