/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearch.model.transform;

import com.amazonaws.services.cloudsearch.model.TextOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextOptionsStaxUnmarshaller
implements Unmarshaller<TextOptions, StaxUnmarshallerContext> {
    private static TextOptionsStaxUnmarshaller instance;

    @Override
    public TextOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        TextOptions textOptions = new TextOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return textOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DefaultValue", targetDepth)) {
                    textOptions.setDefaultValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FacetEnabled", targetDepth)) {
                    textOptions.setFacetEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResultEnabled", targetDepth)) continue;
                textOptions.setResultEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return textOptions;
    }

    public static TextOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TextOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

