/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.StringEntity;

public class MonitorMessage {
    MessageType type;
    List<NamedVal> vals;

    public MonitorMessage(MessageType type) {
        this.type = type;
        this.vals = new ArrayList<NamedVal>();
    }

    public static MonitorMessage parseURI(String uri) {
        try {
            String[] flds = uri.split(" ");
            MessageType type = MessageType.valueOf(flds[0]);
            MonitorMessage m = new MonitorMessage(type);
            for (int i = 1; i < flds.length; ++i) {
                String[] vp = flds[i].split("=");
                if (vp == null || vp.length != 2) continue;
                m.addVal(vp[0], vp[1]);
            }
            return m;
        }
        catch (Exception x) {
            System.err.println(x);
            return null;
        }
    }

    public void addVal(String name, String val) {
        NamedVal ex = this.getNamedVal(name);
        if (ex != null) {
            ex.val = val;
        } else {
            this.vals.add(new NamedVal(name, val));
        }
    }

    NamedVal getNamedVal(String name) {
        for (NamedVal nv : this.vals) {
            if (!nv.name.equals(name)) continue;
            return nv;
        }
        return null;
    }

    public String getVal(String name) {
        for (NamedVal nv : this.vals) {
            if (!nv.name.equals(name)) continue;
            return nv.val;
        }
        return null;
    }

    public StringEntity toStringEntity() throws UnsupportedEncodingException {
        StringBuilder s = new StringBuilder(this.type.toString());
        for (NamedVal nv : this.vals) {
            s.append(" " + nv.name + "=" + nv.val);
        }
        return new StringEntity(s.toString(), "UTF-8");
    }

    public static class NamedVal {
        String name;
        String val;

        public NamedVal(String name, String val) {
            this.name = name;
            this.val = val;
        }
    }

    public static enum MessageType {
        createUser,
        isAuthorizedUser,
        recordBillableUse;

    }
}

