/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui.networkspec;

import com.norbl.cbp.ppe.AmiPPE;
import com.norbl.cbp.ppe.gui.networkspec.AmiChoice;
import com.norbl.util.StringUtil;
import java.awt.Insets;
import javax.swing.JComponent;

public class AmiChoiceU
extends AmiChoice {
    public AmiChoiceU(AmiPPE ami) {
        super(ami);
    }

    public AmiChoiceU() {
    }

    @Override
    public int getNColumns() {
        return 3;
    }

    @Override
    public Object getValue(int iCol) {
        if (this.ami == null) {
            return " ";
        }
        switch (iCol) {
            case 0: {
                return this.ami.amiID;
            }
            case 1: {
                String name = this.ami.getTagVal(AmiPPE.ATag.nameShort);
                if (name == null) {
                    name = this.ami.getTagVal(AmiPPE.ATag.name);
                }
                return name;
            }
            case 2: {
                return this.getPiph();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int iCol) {
        switch (iCol) {
            case 0: {
                return " ";
            }
            case 1: {
                return " ";
            }
            case 2: {
                return "Price";
            }
        }
        return " ";
    }

    @Override
    public double getColumnWeight(int iCol) {
        switch (iCol) {
            case 0: {
                return 0.1;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.1;
            }
        }
        return 0.0;
    }

    @Override
    public int getGridBagAnchor(int iCol) {
        if (iCol == 0) {
            return 512;
        }
        if (iCol == 1) {
            return 512;
        }
        if (iCol <= 2) {
            return 768;
        }
        return 0;
    }

    @Override
    public Insets getInsets(int iCol) {
        switch (iCol) {
            case 0: {
                return new Insets(0, 0, 0, 12);
            }
            case 1: {
                return new Insets(0, 0, 0, 12);
            }
            case 2: {
                return new Insets(0, 0, 0, 0);
            }
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void setColumnHeaderToolTip(int iCol, JComponent c) {
        if (this.getColumnName(iCol).equals("Price")) {
            c.setToolTipText("Price per hour per instance");
        }
    }

    @Override
    public String getToolTip() {
        if (this.ami != null) {
            String nm;
            String uat = this.getUnauthorizedToolTipMessage();
            StringBuilder s = new StringBuilder();
            s.append("<html>");
            if (uat != null) {
                s.append(uat + "<br><br>");
            }
            if ((nm = this.ami.getTagVal(AmiPPE.ATag.nameShort)) == null) {
                nm = this.ami.getTagVal(AmiPPE.ATag.name);
            }
            s.append(nm + "<br><br>");
            if (this.ami.descriptionHtml != null) {
                s.append(this.ami.descriptionHtml);
            } else {
                s.append(this.ami.getTagVal(AmiPPE.ATag.linux));
            }
            s.append("</html>");
            return s.toString();
        }
        return null;
    }

    private String getPiph() {
        if (this.ami == null) {
            return " ";
        }
        return "$" + StringUtil.f2(this.ami.imageCharge);
    }
}

