/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.usermonitor.BadMessageException;
import com.norbl.cbp.ppe.usermonitor.Message;
import com.norbl.cbp.ppe.usermonitor.MessageHandlerException;
import com.norbl.cbp.ppe.usermonitor.ReadWriteConnection;
import com.norbl.cbp.ppe.usermonitor.S3Key;
import com.norbl.cbp.ppe.usermonitor.UserDb;
import com.norbl.cbp.ppe.usermonitor.UserMonitor;
import com.norbl.cbp.ppe.usermonitor.UserStatus;
import com.norbl.util.TimeUtil;
import com.norbl.util.aws.PostPaidPipeline;
import com.norbl.util.aws.SDBAccessException;
import java.io.Serializable;
import java.net.Socket;

public class UserMonitorMessageHandler
implements Runnable {
    public static int GLOBAL_AMOUNT_LIMIT_DEFAULT = 10000;
    public static int CREDIT_LIMIT_DEFAULT = 10000;
    Socket socket;
    ParamsEc2 paramEc2;
    UserDb userDb;
    UserStatus userStatus;
    ReadWriteConnection con;
    String postAuthorizationUrl;
    private static String PAYMENT_REASON = "You will be charged $0.03 US per instance per hour for using Northbranchlogic-ppe AMIs. Please note that this is in addition to Amazon's charges for instances and data tranfers.  You can cancel this authorization at any time by using 'Account -> Cancel authorization for instance billing' in the ec2 network manager application or by sending email to billing@norbl.com. These AMI charges will be billed separately from Amazon's charges.  You will be billed monthly if and when the amount due is > $10.00 US.  If your total never exceeds $10.00 you will never be billed and will not owe anything.";

    public UserMonitorMessageHandler(ParamsEc2 paramEc2, UserDb userDb, UserStatus userStatus, Socket socket, String postAuthorizationUrl) {
        this.paramEc2 = paramEc2;
        this.socket = socket;
        this.userDb = userDb;
        this.userStatus = userStatus;
        this.postAuthorizationUrl = postAuthorizationUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.con = new ReadWriteConnection(this.socket, ReadWriteConnection.HostType.server);
            Serializable x = this.con.readMessage();
            if (UserMonitor.verbose) {
                System.out.println("Read message type " + x.getClass().getName());
            }
            if (!(x instanceof Message)) {
                throw new BadMessageException("MessageHandler received non-message " + x);
            }
            if (UserMonitor.verbose) {
                System.out.println("  " + x.toString());
            }
            try {
                Message reply = null;
                if (x instanceof Message.AddUser) {
                    if (UserMonitor.verbose) {
                        System.out.println("   -> AddUser");
                    }
                    reply = this.addUser((Message.AddUser)x);
                } else if (x instanceof Message.BillableUsage) {
                    if (UserMonitor.verbose) {
                        System.out.println("   -> BillableUsage");
                    }
                    reply = this.recordBillableUsage((Message.BillableUsage)x);
                } else if (x instanceof Message.TestMessage) {
                    if (UserMonitor.verbose) {
                        System.out.println("   -> Test");
                    }
                    reply = new Message.TestMessage("Echo of " + ((Message.TestMessage)x).messsage);
                } else {
                    throw new BadMessageException("Undefined message");
                }
                if (reply != null) {
                    this.con.writeMessage(reply);
                }
            }
            catch (MessageHandlerException mx) {
                this.con.writeMessage(new Message.Error(mx));
            }
        }
        catch (BadMessageException bx) {
        }
        catch (Exception xxx) {
            System.err.println(xxx);
        }
        finally {
            if (this.con != null) {
                this.con.close();
            }
        }
    }

    Message addUser(Message.AddUser m) throws MessageHandlerException {
        try {
            String eid = S3Key.createPeidKey(m.uid);
            String dts = TimeUtil.toDateTimeString(System.currentTimeMillis());
            String callerReference = this.buildCallerReference(m.uid, dts);
            String callerReferenceSender = this.buildCallerReferenceSender(m.uid, dts);
            String callerReferenceSettlement = this.buildCallerReferenceSettlement(m.uid, dts);
            String url = this.postAuthorizationUrl + "/" + "postauth" + "/" + m.uid;
            PostPaidPipeline ppp = new PostPaidPipeline(this.paramEc2.getAwsAccessKey(), this.paramEc2.getAwsSecretKey());
            ppp.setParameters(url, callerReference, callerReferenceSender, callerReferenceSettlement, Integer.toString(GLOBAL_AMOUNT_LIMIT_DEFAULT), Integer.toString(CREDIT_LIMIT_DEFAULT), PAYMENT_REASON, "USD", "CC,ABT,ACH", "4481049601");
            this.userDb.addUser(m.uid, eid, callerReference, callerReferenceSender, callerReferenceSettlement);
            this.userStatus.putStatus(eid, UserStatus.Status.pending);
            return new Message.NewUserUrl(m.uid, eid, ppp.getUrl());
        }
        catch (Exception xx) {
            throw new MessageHandlerException(xx);
        }
    }

    String buildCallerReference(String uid, String dts) {
        return "callerRef_" + uid + "_" + dts;
    }

    String buildCallerReferenceSender(String uid, String dts) {
        return "callerRefSender_" + uid + "_" + dts;
    }

    String buildCallerReferenceSettlement(String uid, String dts) {
        return "callerRefSettlement_" + uid + "_" + dts;
    }

    Message recordBillableUsage(Message.BillableUsage m) throws SDBAccessException {
        if (UserMonitor.verbose) {
            System.out.println("   inc'ing usage for " + m.uid);
        }
        this.userDb.incrementNInstanceHours(m.uid);
        if (UserMonitor.verbose) {
            System.out.println("   inc'ed usage for " + m.uid);
        }
        return new Message.Ok();
    }

    public static enum MessageType {
        addUser;

    }
}

