/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.services.ec2.model.InstanceType;
import com.norbl.cbp.ppe.ConstantsPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import java.io.Serializable;

public class NetworkSpec
implements Serializable {
    static final long serialVersionUID = ConstantsPPE.SERIAL_VERSION_UID;
    public String networkName;
    public InstanceType instanceType;
    public String imageID;
    public int nInstances;
    public String keyName;
    public String securityGroupName;
    public boolean useSpotInstances;
    public double spotPrice;
    public String clusterGroupName;
    public boolean useCluster;
    public int slotsPerHost;
    public boolean disableHyperThreading;
    public String availabilityZone;
    public String userData;

    public NetworkSpec(ParamsEc2 params) {
        this.networkName = params.networkName;
        this.instanceType = params.instanceType;
        this.availabilityZone = null;
        this.nInstances = params.nInstances;
        this.keyName = params.keyName;
        this.securityGroupName = params.securityGroup;
        this.useSpotInstances = params.useSpotInstances;
        this.spotPrice = params.spotPrice;
        this.clusterGroupName = params.clusterGroupName;
        this.useCluster = params.useCluster;
        this.disableHyperThreading = params.disableHyperthreading;
        this.userData = params.uid;
    }

    public NetworkSpec() {
    }

    public boolean isComplete() {
        return !(this.networkName == null || this.instanceType == null || this.imageID == null || this.nInstances <= 0 || this.keyName == null || this.useSpotInstances && Double.isNaN(this.spotPrice) || this.useCluster && this.clusterGroupName == null || this.slotsPerHost <= 0);
    }

    public String listMissingParams() {
        return "Missing params: " + (this.networkName == null ? "networkName " : "") + (this.instanceType == null ? "instanceType " : "") + (this.imageID == null ? "imageID " : "") + (this.nInstances <= 0 ? "nInstances " : "") + (this.keyName == null ? "keyNames " : "") + (!this.useSpotInstances || Double.isNaN(this.spotPrice) ? "spotPrice" : "") + (!this.useCluster || this.clusterGroupName == null ? "clusterGroupName" : "") + (this.slotsPerHost < 1 ? "slotsPerHost" : "");
    }

    public NetworkSpec cloneSpec() {
        NetworkSpec c = new NetworkSpec();
        c.networkName = this.nns(this.networkName);
        c.instanceType = this.instanceType;
        c.nInstances = this.nInstances;
        c.keyName = this.nns(this.keyName);
        c.securityGroupName = this.nns(this.securityGroupName);
        c.useSpotInstances = this.useSpotInstances;
        c.slotsPerHost = this.slotsPerHost;
        c.spotPrice = this.spotPrice;
        c.clusterGroupName = this.nns(this.clusterGroupName);
        c.useCluster = this.useCluster;
        c.disableHyperThreading = this.disableHyperThreading;
        c.userData = this.userData;
        return c;
    }

    private String nns(String x) {
        if (x != null) {
            return new String(x);
        }
        return null;
    }
}

