/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import com.norbl.util.StringUtil;
import rreval.ConnectionJ;
import rreval.ConnectionR;
import rreval.Message;
import rreval.MessageType;
import rreval.Verbose;

public class MessageWrangler {
    protected ConnectionR conR;
    protected ConnectionJ conJ;

    public void setConR(ConnectionR conR) {
        this.conR = conR;
    }

    public void setConJ(ConnectionJ conJ) {
        this.conJ = conJ;
    }

    protected Message createWrongTypeErrorMessage(Message m) {
        String typeS = m != null ? (m.type != null ? m.type.toString() : "null type") : "null message";
        return new Message(MessageType.er, "Error: undefined or inapproriate message type=" + typeS);
    }

    protected void sendErrMToR(String m) {
        try {
            this.conR.writeMessage(new Message(MessageType.er, m));
            Verbose.show("ClientCmdHandler sending error message to client failed: " + m);
        }
        catch (Exception z) {
            System.err.println(StringUtil.toString((Throwable)z));
        }
    }

    protected void sendErrMToR(Exception x) {
        this.sendErrMToR(StringUtil.getExceptionMessage((Throwable)x));
    }

    protected void sendErrMToR(String prefix, Exception x) {
        this.sendErrMToR(prefix + ": " + StringUtil.getExceptionMessage((Throwable)x) + "\n" + StringUtil.exceptionStackToString((Throwable)x));
    }

    protected void sendMessageToR(String m) {
        try {
            if (m == null || m.length() < 1) {
                m = " ";
            }
            this.conR.writeMessage(new Message(MessageType.rj, m));
        }
        catch (Exception z) {
            System.err.println(StringUtil.toString((Throwable)z));
        }
    }
}

