/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.Tag;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ppe.ec2.AmiDescription;
import ppe.ec2.Ec2InstanceType;
import ppe.gui.networkspec.Choice;
import ppe.gui.networkspec.OtherCC;
import ppe.gui.networkspec.RadioButtonCC;

public class AmiChoice
extends Choice {
    Image image;
    String value;
    AmazonEC2Client ec2client;
    List<Tag> tags;

    public AmiChoice(Image image, AmazonEC2Client ec2Client) {
        this.image = image;
        this.ec2client = ec2Client;
        this.tags = image.getTags();
    }

    public AmiChoice() {
        this.image = null;
    }

    @Override
    public String getChoiceType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Object getValue() {
        if (this.image != null) {
            return this.image.getImageId();
        }
        if (this.cc instanceof OtherCC) {
            return ((OtherCC)this.cc).textField.getText();
        }
        if (this.value != null) {
            return this.value;
        }
        throw new RuntimeException("No image or value, cc: " + this.cc);
    }

    @Override
    public String getLabel() {
        if (this.image != null) {
            return this.image.getImageId();
        }
        if (this.cc instanceof OtherCC || this.value != null) {
            return "Other: ";
        }
        throw new RuntimeException("No image, cc: " + this.cc);
    }

    public String getDescription() {
        if (this.image != null) {
            return this.image.getDescription();
        }
        return null;
    }

    @Override
    public void createCC() {
        if (this.image != null) {
            this.cc = new RadioButtonCC(this.getLabel());
        } else {
            this.cc = new OtherCC();
            ((OtherCC)this.cc).setOtherLabel();
            ((OtherCC)this.cc).createComponents();
            ((OtherCC)this.cc).populate();
        }
        this.cc.setEnabled(this.enabled);
        this.cc.setSelected(this.selected);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AmiChoice)) {
            return false;
        }
        AmiChoice o = (AmiChoice)other;
        return this.getValue().equals(o.getValue()) && this.getLabel().equals(o.getLabel());
    }

    public boolean usesParavirtual() {
        if (this.image == null) {
            return false;
        }
        return Ec2InstanceType.isPv(this.image.getVirtualizationType());
    }

    public boolean usesHvm() {
        if (this.image == null) {
            return false;
        }
        return Ec2InstanceType.isHvm(this.image.getVirtualizationType());
    }

    @Override
    public int getNColumns() {
        return 1;
    }

    @Override
    public Object getValue(int iCol) {
        if (this.image == null) {
            return " ";
        }
        switch (iCol) {
            case 0: {
                return this.image.getImageId();
            }
            case 1: {
                return this.listToString(this.getTableVersions(this.getSoftware(this.tags)));
            }
            case 2: {
                return this.getProductCode();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int iCol) {
        switch (iCol) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Versions";
            }
            case 2: {
                return "Product code";
            }
        }
        return "";
    }

    @Override
    public double getColumnWeight(int iCol) {
        switch (iCol) {
            case 0: {
                return 0.1;
            }
            case 1: {
                return 0.2;
            }
            case 2: {
                return 0.1;
            }
        }
        return 0.0;
    }

    @Override
    public int getGridBagAnchor(int iCol) {
        switch (iCol) {
            case 0: {
                return 512;
            }
            case 1: {
                return 512;
            }
            case 2: {
                return 512;
            }
        }
        return 0;
    }

    @Override
    public Insets getInsets(int iCol) {
        switch (iCol) {
            case 0: {
                return new Insets(0, 0, 0, 12);
            }
            case 1: {
                return new Insets(0, 0, 0, 12);
            }
            case 2: {
                return new Insets(0, 0, 0, 0);
            }
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public JComponent getComponent(int iCol) {
        JLabel x = new JLabel(this.toStringNullSpace(this.getValue(iCol)));
        return x;
    }

    private String toStringNullSpace(Object x) {
        if (x != null) {
            return x.toString();
        }
        return " ";
    }

    private String booToString(boolean b) {
        if (b) {
            return "yes";
        }
        return "no";
    }

    public boolean isDevPay() {
        List pcs = this.image.getProductCodes();
        return pcs != null && pcs.size() > 0;
    }

    private String listToString(List<String> strs) {
        if (strs.size() < 1) {
            return "";
        }
        int i = 0;
        StringBuilder s = new StringBuilder();
        for (String str : strs) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(str);
            ++i;
        }
        return s.toString();
    }

    String getProductCode() {
        List pcs = this.image.getProductCodes();
        if (pcs.size() < 1) {
            return "";
        }
        return ((ProductCode)pcs.get(0)).getProductCodeId();
    }

    @Override
    public String getToolTip() {
        String name = this.getName(this.tags);
        List<String> sws = this.getSoftware(this.tags);
        StringBuilder s = new StringBuilder("<html>\n");
        s.append("<u>" + this.image.getImageId() + "</u><br>");
        if (name.length() > 0) {
            s.append(name + "<br>");
        }
        if (sws.size() > 0) {
            s.append("Software:<br>");
            for (String sw : sws) {
                s.append("&nbsp;&nbsp;&nbsp;&nbsp;" + sw + "<br>");
            }
        }
        s.append("Virtualization type: " + this.image.getVirtualizationType() + "<br>");
        s.append("Region: " + this.toStringNullSpace(AmiDescription.getRegion(this.ec2client, this.image.getImageId()).getRegionName()) + "<br>");
        s.append("Product code: " + this.getProductCode() + "<br>");
        s.append("DevPay instance: " + this.booToString(this.isDevPay()) + "<br>");
        s.append("\n<html>");
        return s.toString();
    }

    private String getName(List<Tag> tags) {
        for (Tag t : tags) {
            if (!"Name".equals(t.getKey())) continue;
            return t.getValue();
        }
        return "";
    }

    private List<String> getSoftware(List<Tag> tags) {
        ArrayList<String> sws = new ArrayList<String>();
        for (Tag t : tags) {
            if (t.getKey().equals("Name")) continue;
            sws.add(t.getKey() + " " + t.getValue());
        }
        return sws;
    }

    private List<String> getTableVersions(List<String> str) {
        ArrayList<String> rels = new ArrayList<String>();
        for (String s : str) {
            if (!s.startsWith("ompi ") && !s.startsWith("R ")) continue;
            rels.add(s);
        }
        return rels;
    }
}

