% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-entry.R
\name{time_entries}
\alias{time_entries}
\title{Get time entries}
\usage{
time_entries(
  user_id = NULL,
  start = NULL,
  end = NULL,
  finished = TRUE,
  concise = TRUE,
  ...
)
}
\arguments{
\item{user_id}{User ID}

\item{start}{Start time}

\item{end}{End time}

\item{finished}{Whether to include only finished time intervals (intervals with both start and end time)}

\item{concise}{Generate concise output}

\item{...}{Further arguments passed to \code{\link{paginate}}.}
}
\value{
A data frame with one record per time entry.
}
\description{
Get time entries
}
\examples{
\dontrun{
set_api_key(Sys.getenv("CLOCKIFY_API_KEY"))

USER_ID <- "612b15a4f4c3bf0462192676"

# Specify number of results per page (default: 50).
time_entries(USER_ID, page_size = 200)
# Specify number of pages.
time_entries(USER_ID, pages = 3)
}
}
