% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year-day-boundary}
\alias{year-day-boundary}
\alias{calendar_start.clock_year_day}
\alias{calendar_end.clock_year_day}
\title{Boundaries: year-day}
\usage{
\method{calendar_start}{clock_year_day}(x, precision)

\method{calendar_end}{clock_year_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_day]}

A year-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} at the same precision, but with some components altered to be
at the boundary value.
}
\description{
This is a year-day method for the \code{\link[=calendar_start]{calendar_start()}} and
\code{\link[=calendar_end]{calendar_end()}} generics. They adjust components of a calendar to the
start or end of a specified \code{precision}.
}
\examples{
# Day precision
x <- year_day(2019:2020, 5)
x

# Compute the last day of the year
calendar_end(x, "year")
}
