% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clm_stan.R
\name{clm_stan}
\alias{clm_stan}
\title{Fit a Cumulative Link Model using CmdStanR}
\usage{
clm_stan(
  formula,
  data,
  link = "logit",
  base = "logit",
  threshold = "flexible",
  link_param = NULL,
  prior = NULL,
  chains = 4,
  iter = 2000,
  warmup = NULL,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the model (response ~ predictors)}

\item{data}{A data frame containing the variables in the formula}

\item{link}{Link function. One of "logit" (default), "probit", "cloglog",
"loglog", "cauchit", "tlink", "gev", "aep", "sp", "aranda_ordaz", "log_gamma"}

\item{base}{Base distribution for SP link. One of "logit" (default),
"probit", "cloglog", "loglog", "cauchit", "tlink". Ignored for other link functions.}

\item{threshold}{Threshold structure. One of "flexible" (default),
"equidistant", "symmetric"}

\item{link_param}{A list of link parameters. For flexible links, values can be:
\itemize{
\item Numeric: Use as fixed value (e.g., \code{list(df = 8)})
\item "estimate": Estimate the parameter with Bayesian inference
}}

\item{prior}{Prior specification. Can be either:
\itemize{
\item A \code{clm_prior} object created by \code{\link[=clm_prior]{clm_prior()}}
\item A distribution-based prior using \code{\link[=prior]{prior()}} with distribution functions
(\code{\link[=normal]{normal()}}, \code{\link[=gamma]{gamma()}}, \code{\link[=student_t]{student_t()}}, \code{\link[=cauchy]{cauchy()}})
}}

\item{chains}{Number of MCMC chains (default: 4)}

\item{iter}{Total iterations per chain (default: 2000)}

\item{warmup}{Warmup iterations per chain. If NULL (default), uses floor(iter/2)}

\item{...}{Additional arguments passed to cmdstanr::sample()}
}
\value{
An object of class "clmstan"
}
\description{
Fit a Cumulative Link Model using CmdStanR
}
\examples{
\dontrun{
# Fit a proportional odds model
library(ordinal)
data(wine)
fit <- clm_stan(rating ~ temp + contact, data = wine, link = "logit")
print(fit)

# Fit with t-link (fixed df)
fit_t <- clm_stan(rating ~ temp, data = wine, link = "tlink",
                  link_param = list(df = 8))

# Fit with GEV link (estimate xi)
fit_gev <- clm_stan(rating ~ temp, data = wine, link = "gev",
                    link_param = list(xi = "estimate"))
}
}
