% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotresidualsclmplusmodel.R
\name{plotresiduals}
\alias{plotresiduals}
\title{Plot the hazard model residuals}
\usage{
plotresiduals(clmplusmodel, heat.lim = c(-2.5, 2.5))
}
\arguments{
\item{clmplusmodel}{clmplusmodel object to be plotted.}

\item{heat.lim}{limits in the residuals plot.}
}
\value{
No return value, called to pass method plotresiduals.
}
\description{
This function allows to plot the hazard model residuals on the triangle payments.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- RtTriangle(cumulative.payments.triangle=sifa.mtpl)
hz.chl<-clmplus(sifa.mtpl.rtt, 'a')
plotresiduals(hz.chl)

}
\references{
Hiabu, Munir. “On the relationship between classical chain ladder and granular reserving.” 
Scandinavian Actuarial Journal 2017 (2017): 708 - 729.
}
