% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multichoice.R
\name{split_multichoice}
\alias{split_multichoice}
\title{Split multi-choice data into columns}
\usage{
split_multichoice(
  df,
  quest_cols,
  split = "",
  remove_space = TRUE,
  link = "_",
  remove_cols = TRUE
)
}
\arguments{
\item{df}{A data frame.}

\item{quest_cols}{A vector of column names that contain multi-choice data.}

\item{split}{A string to split the data. Default is \code{""}.}

\item{remove_space}{If \code{TRUE}, remove space in the data.}

\item{link}{A string to link the column name and the option. Default is \code{"_"}.}

\item{remove_cols}{If \code{TRUE}, remove the original columns.}
}
\value{
A data frame with additional columns.
}
\description{
Split multi-choice data into columns, each new column consists of
booleans whether a choice is presented.
}
\examples{
df <- data.frame(q1 = c("ab", "c da", "b a", NA), q2 = c("a b", "a c", "d", "ab"))
split_multichoice(df, quest_cols = c("q1", "q2"))
}
