% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.r
\name{interaction_scan}
\alias{interaction_scan}
\title{Scan for interactions between variables}
\usage{
interaction_scan(
  data,
  y,
  time = NULL,
  predictors = NULL,
  group_vars = NULL,
  covars = NULL,
  try_rcs = TRUE,
  p_adjust_method = "BH",
  save_table = FALSE,
  filename = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string of the outcome variable.}

\item{time}{A character string of the time variable. If \code{NULL}, logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{predictors}{The predictor variables to be scanned for interactions. If \code{NULL}, all variables
except \code{y} and \code{time} are taken as predictors.}

\item{group_vars}{The group variables to be scanned for interactions. If \code{NULL}, all variables
except \code{y} and \code{time} are taken as group variables. The group variables should be categorical. If a
numeric variable is included, it will be split by the median value.}

\item{covars}{A character vector of covariate names.}

\item{try_rcs}{A logical value indicating whether to perform restricted cubic spline interaction analysis.}

\item{p_adjust_method}{The method to use for p-value adjustment for pairwise comparison. Default is "BH".
See \code{?p.adjust.methods}.}

\item{save_table}{A logical value indicating whether to save the results as a table.}

\item{filename}{The name of the file to save the results. File will be saved in \code{.csv} format.}
}
\value{
A data frame containing the results of the interaction analysis.
}
\description{
Scan for interactions between variables and output results. Both logistic and Cox
proportional hazards regression models are supported. The predictor variables in the model are can be
used both in linear form or in restricted cubic spline form.
}
\examples{
data(cancer, package = "survival")
interaction_scan(cancer, y = "status", time = "time", save_table = FALSE)
}
