% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_check.r
\name{answer_check}
\alias{answer_check}
\title{Check answers of multiple choice questions}
\usage{
answer_check(dat, seq, multi_column = FALSE)
}
\arguments{
\item{dat}{A data frame of answers.}

\item{seq}{A vector of correct answers, one element for each question.}

\item{multi_column}{Logical, whether the multi-answers are in multiple columns.}
}
\value{
A data frame of boolean values, with ncol equals the number of questions.
}
\description{
Check answers of multiple choice questions by matching the answers with the correct sequence.
}
\details{
If \code{multi_column} is TRUE, the answers for Multiple-Answer Questions should be in multiple columns
of logicals, with each column representing a choice. The \code{seq} should be a string of \code{"T"} and \code{"F"}.
If \code{multi_column} is \code{FALSE}, the answers for Multiple-Answer Questions should be in one column, and the function
would expect an exact match of \code{seq}.
}
\examples{
dat <- data.frame(Q1 = c("A", "B", "C"), Q2 = c("AD", "AE", "ABF"))
seq <- c("A", "AE")
answer_check(dat, seq)
dat <- data.frame(
  Q1 = c("A", "B", "C"), Q2.A = c(TRUE, TRUE, FALSE),
  Q2.B = c(TRUE, FALSE, TRUE), Q2.C = c(FALSE, TRUE, FALSE)
)
seq <- c("A", "TFT")
answer_check(dat, seq, multi_column = TRUE)
}
