% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{clin_alt_pages}
\alias{clin_alt_pages}
\title{Configure alternating pages during pagination of a clintable}
\usage{
clin_alt_pages(x, key_cols, col_groups)
}
\arguments{
\item{x}{A clintable object}

\item{key_cols}{A character vector of variable names}

\item{col_groups}{A list of character vectors of variable names}
}
\value{
A clintable object
}
\description{
This function configures alternating pages on a clintable object.
}
\examples{
ct <- clintable(mtcars)

clin_alt_pages(
  ct,
  key_cols = c('mpg', 'cyl', 'hp'),
  col_groups = list(
    c('disp', 'drat', 'wt'),
    c('qsec', 'vs', 'am'),
    c('gear', 'carb')
  )
)
}
