% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{claus_2020}
\alias{claus_2020}
\title{Placebo Amplification Data}
\format{
An object of class \code{tbl_df} with 172 rows and 9 columns.

\describe{
\item{id}{Participant ID}
\item{age}{Age}
\item{sex}{Sex}
\item{treatment}{Treatment (TAU for treatment as usual and PA for placebo
amplification)}
\item{time}{Measurement}
\item{bdi}{Beck Depression Inventory (2nd Edition) score (lower is better)}
\item{shaps}{Snaith-Hamilton Pleasure Scale score (higher is better)}
\item{who}{WHO-Five Well-Being Index score (higher is better)}
\item{hamd}{Hamilton Rating Scale for Depression score (lower is better)}
}
}
\source{
\url{https://osf.io/rc754/}
}
\usage{
claus_2020
}
\description{
A dataset containing the data from Claus et al. (2020). In a routine
inpatient setting for unipolar depressive disorders they implemented an
intervention that sought to amplify the placebo response of antidepressants.
In the study, two groups were compared: treatment as usual (TAU) and placebo
amplification (PA). Participants were examined four times during their
treatment.
}
\references{
\itemize{
\item Claus, B. B., Scherbaum, N., & Bonnet, U. (2020). Effectiveness
of an Adjunctive Psychotherapeutic Intervention Developed for Enhancing the
Placebo Effect of Antidepressants Used within an Inpatient-Treatment
Program of Major Depression: A Pragmatic Parallel-Group, Randomized
Controlled Trial. Psychotherapy and Psychosomatics, 89(4), 258-260.
https://doi.org/10.1159/000505855
}
}
\keyword{datasets}
