\name{climdex.txn}
\alias{climdex.txn}
\title{Monthly Minimum of Daily Maximum Temperature}
\usage{
climdex.txn(ci, freq = c("monthly", "annual"))
}
\arguments{
  \item{ci}{Object of type climdexInput.}

  \item{freq}{Time frequency to aggregate to.}
}
\value{
A vector containing the value of the index for each month.
}
\description{
This function computes the climdex index TXn.
}
\details{
This function takes a climdexInput object as input and
computes the monthly or annual minimum of daily maximum
temperature.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create a monthly timeseries of minimum daily maximum temperature.
txn <- climdex.txn(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}},
\code{\link{climdexInput.csv}}.
}
\keyword{climate}
\keyword{ts}

