% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readClickstreams}
\alias{readClickstreams}
\title{Reads a list of clickstreams from a file}
\usage{
readClickstreams(file, sep = ",", header = FALSE)
}
\arguments{
  \item{file}{The name of the file which the clickstreams
  are to be read from. Each line of the file appears as one
  click stream. If it does not contain an absolute path,
  the file name is relative to the current working
  directory, \code{\link{getwd}}.}

  \item{sep}{The character used to separate clicks (default
  is \dQuote{,}).}

  \item{header}{A logical flag indicating whether the first
  entry of each line in the file is the name of the
  clickstream user.}
}
\value{
A list of clickstreams. Each element is a vector of
characters representing the clicks. The name of each list
element is either the header of a clickstream file or a
unique number.
}
\description{
Reads a list of clickstream from a csv-file.
}
\examples{
clickstreams<-c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf<-tempfile()
writeLines(clickstreams, csf)
cls<-readClickstreams(csf, header=TRUE)
print(cls)
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\seealso{
\code{\link{print.Clickstreams}},
\code{\link{randomClickstreams}}
}

