% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlang.R
\name{cli_abort}
\alias{cli_abort}
\alias{cli_warn}
\alias{cli_inform}
\title{Signal an error, warning or message with a cli formatted
message}
\usage{
cli_abort(
  message,
  ...,
  call = .envir,
  .envir = parent.frame(),
  .frame = .envir
)

cli_warn(message, ..., .envir = parent.frame())

cli_inform(message, ..., .envir = parent.frame())
}
\arguments{
\item{message}{It is formatted via a call to \code{\link[=cli_bullets]{cli_bullets()}}.}

\item{...}{Passed to \code{\link[rlang:abort]{rlang::abort()}}, \code{\link[rlang:abort]{rlang::warn()}} or
\code{\link[rlang:abort]{rlang::inform()}}.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}

\item{.envir}{Environment to evaluate the glue expressions in.}

\item{.frame}{The throwing context. Used as default for
\code{.trace_bottom}, and to determine the internal package to mention
in internal errors when \code{.internal} is \code{TRUE}.}
}
\description{
These functions let you create error, warning or diagnostic
messages with cli formatting, including inline styling,
pluralization and glue substitutions.
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{n <- "boo"
cli_abort(c(
        "\{.var n\} must be a numeric vector",
  "x" = "You've supplied a \{.cls \{class(n)\}\} vector."
))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;color: #B58900;">Error</span><span style="font-weight: bold;">:</span>                                                                          
#> <span style="color: #B58900;">!</span> `n` must be a numeric vector                                                  
#> <span style="color: #DC322F;">✖</span> You've supplied a <span style="color: #268BD2;">&lt;character&gt;</span> vector.                                         
#> <span style="color: #002B36;">Run `rlang::last_error()` to see where the error occurred.</span>                      
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{len <- 26
idx <- 100
cli_abort(c(
        "Must index an existing element:",
  "i" = "There \{?is/are\} \{len\} element\{?s\}.",
  "x" = "You've tried to subset element \{idx\}."
))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;color: #B58900;">Error</span><span style="font-weight: bold;">:</span>                                                                          
#> <span style="color: #B58900;">!</span> Must index an existing element:                                               
#> <span style="color: #2AA198;">ℹ</span> There are 26 elements.                                                        
#> <span style="color: #DC322F;">✖</span> You've tried to subset element 100.                                           
#> <span style="color: #002B36;">Run `rlang::last_error()` to see where the error occurred.</span>                      
</pre></div>
}}
}
\seealso{
These functions support \link[=inline-markup]{inline markup}.

Other functions supporting inline markup: 
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_bullets}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status_update}()},
\code{\link{cli_status}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
