% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crayonex.R
\name{ansi_nchar}
\alias{ansi_nchar}
\title{Count number of characters in an ANSI colored string}
\usage{
ansi_nchar(x, ...)
}
\arguments{
\item{x}{Character vector, potentially ANSO styled, or a vector to be
coarced to character.}

\item{...}{Additional arguments, passed on to \code{base::nchar()}
after removing ANSI escape sequences.}
}
\value{
Numeric vector, the length of the strings in the character
vector.
}
\description{
This is a color-aware counterpart of \code{\link[base:nchar]{base::nchar()}},
which does not do well, since it also counts the ANSI control
characters.
}
\examples{
str <- paste(
  col_red("red"),
  "default",
  col_green("green")
)

cat(str, "\n")
nchar(str)
ansi_nchar(str)
nchar(ansi_strip(str))
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()}
}
\concept{ANSI string operations}
