\name{ggEnsTrend}
\alias{ggEnsTrend}
\title{
Trend of the test accuracies
}
\description{
The \code{ggEnsTrend} function displays the average test accuracies for every new classifier added to the ensemble, as constructed by the \code{\link{cfBuild}} function.  
}
\usage{
ggEnsTrend(ensObj, xlabel = NULL, ylabel = NULL, showText = FALSE, xlims = NULL, 
            ylims = NULL, ...)
}
\arguments{
  \item{ensObj}{The R object as generated by \code{\link{cfBuild}}}
  \item{xlabel}{A sub title for the x axis (optional field).}
  \item{ylabel}{A sub title for the y axis (optional field).}
  \item{showText}{Boolean value, by default set to \code{FALSE}. If \code{showText=TRUE}, then the values of all test accuracies in the ensemble are displayed in the plot.}
  \item{xlims}{A vector of numeric values that specifies the minimum and maximum values in the x axis.}
  \item{ylims}{A vector of numeric values that specifies the minimum and maximum values in the y axis.}
  \item{\dots}{Further arguments and graphical parameters passed to the ggplot.}
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]
            
ens <- cfBuild(irisData, irisClass, bootNum = 100, ensNum = 100, parallel = TRUE, 
               cpus = 4, type = "SOCK")
              
ggEnsTrend(ens)
ggEnsTrend(ens, showText  = TRUE)
ggEnsTrend(ens, showText  = TRUE, ylims=c(90, 100))
}
}
\keyword{hplot}
