% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calib.t}
\alias{calib.t}
\title{Comparison dates calibrated using both the t distribution (Christen and Perez 2009) and the normal distribution.}
\usage{
calib.t(
  y = 2450,
  error = 50,
  t.a = 3,
  t.b = 4,
  cc = 1,
  postbomb = NULL,
  cc1 = "IntCal20",
  cc2 = "Marine20",
  cc3 = "SHCal20",
  cc4 = "mixed",
  ccdir = "",
  Cutoff = 1e-05,
  times = 8,
  rule = 1
)
}
\arguments{
\item{y}{The reported mean of the date.}

\item{error}{The reported error of the date.}

\item{t.a}{Value for the t parameter \code{a}.}

\item{t.b}{Value for the t parameter \code{b}.}

\item{cc}{calibration curve for C14 dates (1, 2 or 3).}

\item{postbomb}{Which postbomb curve to use for negative 14C dates}

\item{cc1}{For northern hemisphere terrestrial C14 dates.}

\item{cc2}{For marine C14 dates.}

\item{cc3}{For southern hemisphere C14 dates.}

\item{cc4}{A custom calibration curve}

\item{ccdir}{Directory where the calibration curves for C14 dates \code{cc} are allocated. By default \code{ccdir=""}. 
Use \code{ccdir="."} to choose current working directory. Use \code{ccdir="Curves/"} to choose sub-folder \code{Curves/}.}

\item{Cutoff}{Threshold above which calibrated probabilities are plotted}

\item{times}{8 by default.}

\item{rule}{How should R's approx function deal with extrapolation. If \code{rule=1}, the default, then NAs are returned for such points and if it is 2, the value at the closest data extreme is used.}
}
\description{
Visualise how a date calibrates using the t distribution and the normal distribution.
}
\details{
Radiocarbon and other dates are usually modelled using the normal distribution (red curve). The t approach (grey distribution) however allows for wider tails and thus tends to better accommodate outlying dates. This distribution requires two parameters, called 'a' and 'b'.
}
\examples{
calib.t() 

}
\author{
Maarten Blaauw
}
