% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postanalysis.R
\name{plot_proxies}
\alias{plot_proxies}
\title{Produce a plot of proxy values against calendar age.}
\usage{
plot_proxies(prox, errors = TRUE, proxcol = grey(0.5), revyr = TRUE)
}
\arguments{
\item{prox}{Position of the proxy that should be plotted, e.g. \code{1} for the first proxy in the file.}

\item{errors}{Plot an error envelope.}

\item{proxcol}{Colour of the error envelope.}

\item{revyr}{Direction of the calendar scale (\code{revyr=TRUE} will reverse the calendar scale from the default \code{FALSE}).}
}
\value{
A plot of the age model function with proxies.
}
\description{
Produce a plot of proxy values against calendar age.
}
\details{
Only works after running clam on the core using \code{proxies=TRUE}. Requires a file containing the core depths as the first column, 
and any proxy values on subsequent columns. Values should be separated by comma's. The file should be stored as a .csv file in the core's directory.
}
\examples{
clam(coredir=tempdir(), proxies=TRUE)
plot_proxies(3)
plot_proxies(3, revyr=FALSE)
}
\author{
Maarten Blaauw
}
