% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/related_delete.R
\name{related_delete}
\alias{related_delete}
\title{Delete a related item.}
\usage{
related_delete(id, url = get_default_url(), key = get_default_key(),
  ...)
}
\arguments{
\item{id}{(character) Resource identifier.}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Delete a related item.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package and a related item
res <- package_create("hello-venus2") \%>\%
   related_create(title = "my resource",
                  type = "visualization")

# show the related item
related_delete(res)
## or with id itself:
## related_delete(res$id)
}
}
